/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Skill;

public class Category {
    private final ResourceLocation categoryId;

    public Category(ResourceLocation categoryId) {
        this.categoryId = categoryId;
    }

    public ResourceLocation getId() {
        return this.categoryId;
    }

    public Optional<Skill> getSkill(String skillId) {
        if (SkillsMod.getInstance().hasSkill(this.categoryId, skillId)) {
            return Optional.of(new Skill(this, skillId));
        }
        return Optional.empty();
    }

    private List<Skill> getSkills() {
        return SkillsMod.getInstance().getSkills(this.categoryId).orElseThrow().stream().map(skillId -> new Skill(this, (String)skillId)).toList();
    }

    public Collection<Skill> getUnlockedSkills(ServerPlayer player) {
        return SkillsMod.getInstance().getUnlockedSkills(player, this.categoryId).orElseThrow().stream().map(skillId -> new Skill(this, (String)skillId)).toList();
    }

    public void unlock(ServerPlayer player) {
        SkillsMod.getInstance().unlockCategory(player, this.categoryId);
    }

    public void lock(ServerPlayer player) {
        SkillsMod.getInstance().lockCategory(player, this.categoryId);
    }

    public void erase(ServerPlayer player) {
        SkillsMod.getInstance().eraseCategory(player, this.categoryId);
    }

    public void resetSkills(ServerPlayer player) {
        SkillsMod.getInstance().resetSkills(player, this.categoryId);
    }

    public int getExperience(ServerPlayer player) {
        return SkillsMod.getInstance().getExperience(player, this.categoryId).orElseThrow();
    }

    public void setExperience(ServerPlayer player, int amount) {
        SkillsMod.getInstance().setExperience(player, this.categoryId, amount);
    }

    public void addExperience(ServerPlayer player, int amount) {
        SkillsMod.getInstance().addExperience(player, this.categoryId, amount);
    }

    public int getExtraPoints(ServerPlayer player) {
        return SkillsMod.getInstance().getExtraPoints(player, this.categoryId).orElseThrow();
    }

    public void setExtraPoints(ServerPlayer player, int count) {
        SkillsMod.getInstance().setExtraPoints(player, this.categoryId, count);
    }

    public void addExtraPoints(ServerPlayer player, int count) {
        SkillsMod.getInstance().addExtraPoints(player, this.categoryId, count);
    }

    public int getPointsLeft(ServerPlayer player) {
        return SkillsMod.getInstance().getPointsLeft(player, this.categoryId).orElseThrow();
    }

    public int getCurrentLevel(ServerPlayer player) {
        return SkillsMod.getInstance().getCurrentLevel(player, this.categoryId).orElseThrow();
    }

    public int getCurrentExperience(ServerPlayer player) {
        return SkillsMod.getInstance().getCurrentExperience(player, this.categoryId).orElseThrow();
    }

    public int getRequiredExperience(ServerPlayer player) {
        return SkillsMod.getInstance().getRequiredExperience(player, this.categoryId).orElseThrow();
    }
}

